# Test Maintenance

Use this scenario when updating or debugging existing suites and flows.

## Intent and Scope

Apply this scenario for requests such as:
1. "Fix failing flow X."
2. "Refactor or optimize existing suite steps."
3. "Update assertions after API behavior change."
4. "Investigate regression in a known suite."
5. "Adjust tests because server logic changed."
6. "Update flows after API contract/header/auth changes."

Primary focus:
1. Update existing tests to stay aligned with backend/product behavior changes.
2. Keep test intent stable while adapting request/response expectations.
3. Minimize unnecessary rewrites; patch only impacted flow sections.

## Input Checklist

Collect before changes:
1. Target suite path or suite id.
2. Failing behavior, expected behavior, and urgency.
3. Branch to patch or branch to create.
4. Runtime overrides required for reliable repro.
5. What changed in backend behavior:
   - endpoint contract
   - required headers
   - auth requirements
   - status codes
   - response schema
   - business-rule logic

## Workflow

1. Identify target suite in `loadmill-suites/`.
2. Capture and restate the backend/API delta that requires test updates.
3. Reproduce failure context with recent run artifacts if available.
4. Identify exact impacted flows and steps.
5. Patch flow logic in place:
   - request payload/query/path updates
   - header/auth updates
   - assertion updates
   - extraction updates
6. Re-check dependent flows because upstream flow changes can affect downstream steps.
7. Validate suite with `validate_test_suite`.
8. Fix all validation errors before run.
9. Commit to a descriptive branch.
10. Ask for required runtime overrides.
11. Run the updated suite using `run_test_suite`.
12. Fetch run details with `get_test_suite_run`.
13. Inspect failing flow runs using `get_test_suite_flow_run`.
14. Summarize failing flow, likely cause, and proposed fix.
15. Iterate until pass or explicit blocker.
16. Suggest PR and merge follow-up.

## Troubleshooting

### New/updated suite not found when running from branch

Cause:
1. Branch does not contain expected YAML commit.
2. Selected run branch does not match patch branch.

Fix:
1. Confirm suite file path and filename format.
2. Confirm commit is on the selected branch.
3. Re-run from that branch.

### Validation fails

Cause:
1. YAML/JSON parse issues.
2. Schema mismatch.
3. Server-side validation rejection.

Fix:
1. Resolve input/parsing issues first.
2. Resolve schema errors next.
3. Resolve server validation errors last.
4. Re-validate before any execution attempt.

### Intermittent or flaky failures

Fix:
1. Re-run to separate persistent failures from transient failures.
2. Compare failing flows across runs.
3. Escalate as flaky if failures are non-deterministic and environment-linked.

### Backend changed and many tests fail at once

Fix:
1. Identify shared contract/header/auth change affecting multiple flows.
2. Apply minimal consistent patch across impacted flows.
3. Validate and run in batches to confirm recovery progressively.

## Reporting Template

Use this output shape:
1. `Suite`: file path and suite id.
2. `Backend delta`: what changed in server/API behavior.
3. `Change`: what was updated in tests.
4. `Validation`: pass/fail and reason.
5. `Run`: id and link.
6. `Failures`: failing flow ids/names only.
7. `Next`: rerun, open PR, or escalate blocker.

## Loadmill UI Sync Guidance

1. Open suite in Loadmill UI.
2. Open `Github Sync`.
3. Select branch.
4. Checkout latest commit in branch history.
5. Warn user this overwrites unsynced UI changes.

## Done Criteria

1. Target bug/update is implemented in YAML.
2. Backend/API behavior change is reflected in requests/assertions.
3. Validation passes.
4. Post-change run status is reported.
5. Remaining risk and next action are explicit.
