# Test Generation

Use this scenario when creating a new suite or adding new coverage that does not already exist.

## Intent and Scope

Apply this scenario for requests such as:
1. "Create a new suite for feature X."
2. "Add net-new flows for endpoint Y."
3. "Generate baseline coverage for a new module."

Do not use this scenario when only patching existing flows. Route those to `test-maintenance.md`.

## Mandatory Decision Gate

Before writing any new test content, determine which path fits the request:
1. `Path A`: add new flow(s) to an existing suite.
2. `Path B`: create a brand new suite.

Always perform this decision process first:
1. Parse the user prompt for domain, feature, endpoint, and intent.
2. Scan existing files in `loadmill-suites/` for potential matching suites.
3. Propose the best target:
   - existing suite candidate(s), or
   - reason no suitable suite exists.
4. Ask the user to confirm the target path before creating tests.

Do not proceed with flow/suite creation until the user confirms the selected path.

## Input Checklist

Collect before implementation:
1. Suite purpose and target user journey/API domain.
2. Initial flow list and expected outcomes.
3. Required runtime parameters for execution.
4. Preferred branch name or branch naming pattern.

## Workflow - Path A (New Flows in Existing Suite)

1. Identify the best existing suite candidate by scanning `loadmill-suites/`.
2. Present rationale and ask user confirmation to add flows there.
3. Implement new flow(s) in the confirmed suite.
4. Keep flow ordering intentional to avoid downstream breakage.
5. Reuse shared flow patterns where appropriate.
6. Validate with `validate_test_suite`.
7. Fix all validation failures before moving forward.
8. Create a descriptive branch and commit changes.
9. Ask for overrides in `key=value,key2=value2` format if execution is requested.
10. Run suite from the feature branch using `run_test_suite`.
11. Fetch status/details with `get_test_suite_run`.
12. If needed, inspect failing flow runs with `get_test_suite_flow_run`.
13. Share run link and concise pass/fail summary.
14. Suggest PR creation and post-merge GitHub Sync checkout in Loadmill UI.

## Workflow - Path B (New Suite)

1. Explain why no existing suite is a good fit and ask user confirmation.
2. Create a new empty suite with Loadmill MCP `create_new_test_suite`.
3. Capture the returned suite id.
4. Create `loadmill-suites/{suite_name}.{suite_id}.yaml`.
5. Implement initial flows and keep flow ordering intentional.
6. Validate with `validate_test_suite`.
7. Fix all validation failures before moving forward.
8. Create a descriptive branch and commit changes.
9. Ask for overrides in `key=value,key2=value2` format if execution is requested.
10. Run suite from the feature branch using `run_test_suite`.
11. Fetch status/details with `get_test_suite_run`.
12. If needed, inspect failing flow runs with `get_test_suite_flow_run`.
13. Share run link and concise pass/fail summary.
14. Suggest PR creation and post-merge GitHub Sync checkout in Loadmill UI.

## Naming and Layout

1. Keep suite filename format exactly `{suite_name}.{suite_id}.yaml`.
2. Keep suite name clear and stable; avoid ambiguous abbreviations.
3. Reuse shared flows when possible instead of duplicating logic.
4. Keep flows deterministic and explicit with assertions and extractions.
5. Use existing files in `loadmill-suites/` as formatting/style references.

## Validation and Quality Bar

1. Require a full validation pass before declaring completion.
2. Treat both schema and server-side errors as blockers.
3. Resolve parse/input errors first, then schema/server issues.
4. Ensure each new flow has clear success criteria.
5. Ensure user-approved target (existing suite vs new suite) is recorded before edits.

## Common Failure Modes

### Run returns not found

Cause:
1. Suite file not committed/pushed on selected branch.
2. Wrong suite id or branch selected in run call.

Fix:
1. Verify file exists with exact `{suite_name}.{suite_id}.yaml` naming.
2. Verify commit is on the selected branch.
3. Re-run using correct suite id and branch.

### Validation passes locally but run still fails

Cause:
1. Runtime data/environment mismatch.
2. Missing/incorrect override parameters.

Fix:
1. Reconfirm required overrides with user.
2. Re-run with corrected overrides.

## Done Criteria

1. Suite YAML exists in `loadmill-suites/`.
2. Validation passes with no unresolved issues.
3. Run result is shared when execution was requested.
4. Next action is explicit: rerun, PR, or merge follow-up.
