---
name: loadmill
description: Create, maintain, and run Loadmill test assets using MCP workflows. Use when users need to generate new suites/flows, update or debug existing test YAML, or run regression plans by labels during feature development with clear run-status reporting and failure triage.
---

# Loadmill

Act as an expert Loadmill suite maintainer and execution partner.

Use this skill to drive end-to-end workflows for:
1. Creating suites and new coverage.
2. Maintaining existing suites and flows.
3. Running regression plans by labels during feature development.

Keep the workflow deterministic: collect inputs, execute tools, report concrete outcomes, and define the next action.

## Routing

1. Open `references/test-generation.md` when the user asks to create a new test suite or add new test coverage from scratch.
2. Open `references/test-maintenance.md` when the user asks to edit, fix, refactor, validate, or troubleshoot existing suites and flows.
3. Open `references/test-runner.md` when the user asks to run tests repeatedly during development, especially regression plans filtered by labels.
4. If the request combines scenarios, prefer this sequence:
   - Run current regression checks first (`test-runner`).
   - Apply fixes/refactors second (`test-maintenance`).
   - Add new coverage last (`test-generation`).

## MCP Requirement

This skill requires working with Loadmill MCP.

Loadmill MCP provides all required actions for this skill, including:
1. Discovering relevant suites/plans/labels.
2. Creating suites and validating test definitions.
3. Running suites/plans and tracking execution status.
4. Investigating failures and guiding next steps.

## Global Rules

1. Treat `loadmill-suites/` as source of truth for suite YAML files.
2. Validate every modified or newly created suite before completion.
3. Ask for required runtime overrides before execution.
4. Confirm each major step with the user before proceeding to the next major step.
5. Use concise progress updates in this shape: target, action, result, next step.
6. Return run links whenever execution occurs.
7. Warn that GitHub Sync checkout in Loadmill UI overwrites unsynced UI changes.

## Execution Contracts

1. Treat `overrideParameters` as a strict comma-separated `key=value` string.
2. Reject malformed pairs early and request corrected input before run.
3. Run suite from branch when branch-specific changes must be tested.
4. For plan runs during development, require explicit labels and keep label sets focused.
5. For failures, produce a short triage artifact:
   - failing unit (suite/flow)
   - likely cause
   - suggested fix
   - rerun recommendation

## Validation Contracts

1. Run `validate_test_suite` before considering a suite change complete.
2. Interpret validation outcomes by `validationType`:
   - `input`: missing or invalid args to validator.
   - `parsing`: invalid YAML/JSON format.
   - `schema`: JSON schema mismatch.
   - `server`: backend validation rejection.
   - `complete`: full validation passed.
3. Fix all blocking issues before run execution.

## Required Final Output

Return a completion summary with:
1. Scenario used (`generation`, `maintenance`, or `runner`).
2. Exact files changed in `loadmill-suites/` when applicable.
3. Validation result and type.
4. Run ids and run links when execution occurred.
5. Recommended next step (rerun, PR, merge, or UI sync action).
